package jp.mosp.common;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

public class DataSourceUtility {

	/**
	 * Tomcat5.5pConst
	 */
	private static final String TOMCAT_SERVER_ENV = "java:comp/env";

	public static final String USE_DATA_SOURCE_MESSAGE = "use DataSource.";

	/**
	 * DataSource\bh
	 * @param DATASOURCE f[^\[X
	 * @return
	 */
	public static DataSource getDataSource(String DATASOURCE) {
		DataSource ds = null;
		try {
			Context ctx = new InitialContext();
			Context env = (Context)ctx.lookup(TOMCAT_SERVER_ENV);
			if (DATASOURCE != null && DATASOURCE.length() != 0) {
				ds = (DataSource)env.lookup(DATASOURCE);
			}
		} catch (NamingException e) {
			ds = null;
		}
		return ds;
	}

	/**
	 * DataSourcepۃ\bh
	 * @param DATASOURCE f[^\[X
	 * @return
	 * <p>
	 * DataSourcepł̂ȂtrueAłȂꍇfalse
	 * </p>
	 */
	public static boolean canUseDataSource(String DATASOURCE) {
		return getDataSource(DATASOURCE) == null? false: true;
	}

}
